/**
 * Class Quick Nick and Quote
 * @author mad@Max
 */
function QNNQ(){
    this.text = null;
    this.nick = null;
    this.gid = null;
    this.uid = null;
    this.vbe = vB_Editor[QR_EditorID]
    this.wwm = this.vbe.wysiwyg_mode;
}

QNNQ.prototype.findPid = function somefunc(obj){
    var match;
    obj = obj.parentNode;
    while (match = obj.id.match(/post_([0-9]+)/) == null) {
        obj = obj.parentNode;
    }
    return match[1];
};

QNNQ.prototype.Quote = function(nick, pid){
    this.nick = nick;
    this.sel = this.catchSel();
    if (this.sel != "") {
        if (this.wwm) {
            //text = text.replace(/\r?\n/g, '\r\n');
            var regex = new RegExp('([\r\n]|^[\r\n]*)([/\r?\n/g])', 'gi');
            text = PHP.trim(this.sel).replace(regex, '$1<br />');
        }
        else {
            // do nothing
        }
        this.text = '[QUOTE=' + this.nick + ';' + pid + ']' + this.sel + '[/QUOTE]';
        this.Insert();
    }
};

QNNQ.prototype.Nick = function(nick, gid, uid){
    this.nick = nick;
    this.gid = gid;
    this.uid = uid;
    var i, bbl, bbr, linkedl = linkedr = '';
    if (this.uid != null) {
        linkedl = this.wwm ? '<a href="member.php?u=' + this.uid + '">' : '[url="' + qnnqurl + '/member.php?u=' + this.uid + '"]';
        linkedr = this.wwm ? '</a>, ' : '[/url], ';
    }
    if (this.nick != selfname) {
        if (PHP.in_array(this.gid, qng.split(',')) != -1) {
            var grp = clrgrp[this.gid];
            bbl = this.wwm ? grp[0] : grp[2];
            bbr = this.wwm ? grp[1] : grp[3];
            this.text = linkedl + bbl + this.nick + bbr + linkedr;
        }
        else {
            this.text = linkedl + (this.wwm ? '<b>' : '[b]') + this.nick + (this.wwm ? '</b>' : '[/b]') + linkedr;
        }
        this.Insert();
    }
};

QNNQ.prototype.NotEmpty = function(text){
    var arrayCheck = ['', '<br />', '<br>', '<P>&nbsp;</P>', '&nbsp;', '<b></b>', '<b></b><br>', '<P></P>'];
    if (PHP.in_array(text, arrayCheck) == -1) {
        return true;
    }
    else {
        return false;
    }
};

QNNQ.prototype.Insert = function(){
    if (!qr_active) {
        qr_replytothread_handle_activate(false);
    }
    var exist = this.vbe.get_editor_contents();
    var delimiter = '';
    if (this.NotEmpty(exist)) {
        delimiter = this.wwm ? '<br />' : '\n';
    }
    else {
        exist = '';
    }
    this.wwm ? this.vbe.check_focus() : document.quick_reply.message.focus();
    if (exist == '') {
        this.vbe.write_editor_contents('', false);
    }
    this.vbe.insert_text(delimiter + this.text, delimiter.length + this.text.length, 0);
};

QNNQ.prototype.catchSel = function(){
    var selection = '';
    if (window.getSelection && !window.opera) {
        selection = window.getSelection().toString();
    }
    else 
        if (document.getSelection) {
            selection = document.getSelection();
        }
        else 
            if (document.selection && document.selection.createRange) {
                selection = document.selection.createRange().text;
            }
    return selection;
};

var QNNQ = new QNNQ();