<?php
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

// Register with the Plugin Manager
$tmp = new JoomapPluginVirtuemart();
JoomapPlugins::addPlugin($tmp);

/**
 * A Plugin to show Virtuemart categories and items in the Joomap Sitemap.
 *
 * @package Plugins 
 * @author Daniel Grothe
 * @version $Id: virtuemart.plugin.php 12 2008-08-17 20:51:27Z koders.de $
 */
class JoomapPluginVirtuemart {

	/**
	 * Keeps the reference of the calling Joomap instance.
	 * @var Joomap
	 */
	var $joomap;
	
	/**
	 * Keeps the reference of the currenty processed Menu-Item.
	 *
	 * @var stdClass
	 */
	var $menuItem;
	
	/**
	 * Checks wether this Plugin is able to handle the passed Menu-Item. 
	 *
	 * @param Joomap $joomap
	 * @param Object $menuItem
	 * @return bool
	 */
	function isOfType(&$joomap, &$menuItem) {
		return ($menuItem->option == 'com_virtuemart');
	}

	/**
	 * Processes the Menu-Item and creates a tree of content-leafs.
	 *
	 * @param Joomap $joomap
	 * @param stdClass $menuItem 
	 * @return array|null
	 */
	function &getTree(&$joomap, &$menuItem) {
		$this->joomap =& $joomap;
		$this->item =& $menuItem;
		
		// copied from: /administrator/components/com_virtuemart/virtuemart.cfg.php
		define('VM_TABLEPREFIX', 'vm');	
		
		// required classes
		
		$classPath = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_virtuemart'.DS.'classes';
		require_once $classPath.DS.'vmAbstractObject.class.php';
		require_once $classPath.DS.'ps_database.php';
		require_once $classPath.DS.'ps_product_category.php';
		
		// list all published virtuemart categories
		
		$categories = ps_product_category::getCategoryTreeArray();
		
		$list = array();
		foreach ($categories as $row) {
			if ($row['category_publish'] == 'Y') {
				$node = new stdclass;
				
				$node->id = $menuItem->id;
				$node->browserNav = $menuItem->browserNav;
			    $node->name = $row['category_name'];
				//$node->modified = intval($row->mdate);
				$node->link = $menuItem->link.'&amp;page=shop.browse&amp;category_id='.$row['category_child_id'];
				$node->pid = $row['category_parent_id'];
				
			    $list[$row['category_child_id']] = $node;
			}
	    }
		
		foreach ($list as $id => $cat ) {										// move children into their parent nodes
			if ($cat->pid > 0  && isset($list[$cat->pid]) ) {
				$list[$cat->pid]->tree[] = &$list[$id];
			}
		}
		
		foreach ($list as $id => $cat) {										// remove children from top tree
			if ($cat->pid > 0) {
				unset ($list[$id]);
			}
		}
		return $list;
	}
	
	function getCategoryItems($id) {
		return $content;
	}
}
?>
